package com.vmware.samples.viewspropertiesui.model {
import com.vmware.core.model.DataObject;

[Bindable]
[Model(type="VirtualMachine")]
/**
 * A data model of VM properties to display as list items in this sample.
 */
public class VmDataItem extends DataObject {

    [Model(property="name")]
    /**
     * The name of this VirtualMachine.
     */
    public var name:String;

    [Model(property="runtime.powerState")]
    /**
     * The powerstate of this VirtualMachine.
     */
    public var powerState:String;

    [Model(property="config.template")]
    /**
     * True if this VirtualMachine is a template.
     * (Uses the "template" property of the VirtualMachineConfigInfo returned
     * by the "config" property of a VM)
     */
    public var isTemplate:Boolean;

    [Model(property="runtime.maxCpuUsage")]
    /**
     * The current upper-bound on CPU usage.
     * (Uses the "maxCpuUsage" property of the VirtualMachineRuntimeInfo returned
     * by the "runtime" property of a VM)
     */
    public var maxCpuUsage:Number;
}
}
